	function [Z1, P1, Z2, P2, Att] = factors(ncoe,idelay,nbands,edge,des)

	% Compute first and second-order denominator factors of 
	% an allpass filter from the beta-parameters
	
	% <-------------------------------------------------------------- << DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m
	% <---------------------------------------------------------------<< DH <<<
	% c1(i)   1st-order coefficients   (1st-order term: 1 + c1*z^-1)
	% c2(i)   2nd-order coefficients   (2nd-order term: 1 + c1*z^-1 + c2*z^-2)
	% idelay  number of delay elements in branch 2
	% <--- edited Jan-29-2007 with MATLAB R2006a ---------------------<< DH <<<
	global OME OMEXOME BETA % global variables from main function  
	nall = length(OME);       % Pnall(s) is generated through the recurrence 
	nall1 = nall+1;           % formula, P0(s) = 1
	% P1(s) = 1+BETA(1)*s
	% Pr(s) = Pr-1(s)+BETA(r)*[s^2+OMEXOME(r-1)]*Pr-2(s)
	% where r = 2,3,...,nall 
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2019-03-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	

	% <--- Compute coefficients of an s-domain polynomial ------------<< DH <<<
	% <--- from the beta-parameters: ---------------------------------<< DH <<<
	c1(2:nall1) = 0;c2(2:nall1) = 0;c1(1) = 1;c2(1) = 1;c2(2) = BETA(1);
	for i = 3:nall1
		i1 = i-1;
		for j = i:-1:3
			a = c2(j);
			c2(j) = a+BETA(i1)*(c1(j-2)+OMEXOME(i-2)*c1(j));
			c1(j) = a;
		end
		for j = 2:-1:1
			a = c2(j);
			c2(j) = a+BETA(i1)*OMEXOME(i-2)*c1(j); 
			c1(j) = a;                             
		end                                       
	end                                         
	c1 = fliplr(c2/c2(1));                       
	
	% <--- find the roots of the polynomial --------------------------<< DH <<<
	r = roots(c1);                               
	% <--- real and imaginary zeroes: --------------------------------<< DH <<<
	n1 = 0;n2 = 51; % max amount of zeroes
	m = nall;i = 1;
	
	while(i <=  m)
		a = real(r(i));                  % real part of i:th zero
		b = imag(r(i));                  % imaginary part of i:th zero
		if (i  ==  m | abs(b) < 1E-8)    % if real zero
			n1 = n1+1;                   % one more real zero
			x1(n1) = -a;
			x2(n1) = 0;
		else
			ami = 1E10;             % default value for distance a-min
			for j = i+1:m           % searching pair to current zero
				aa = a-real(r(j));  % pair, if real values are same
				bb = b+imag(r(j));  % pair, if opposite side of imaginary axis
				aa = aa*aa+bb*bb;   % zero if pair found
				if (aa < ami)       % testing if current distance is minimum
					ami = aa;       % if it is, then its new minimum value
					jj = j;         % and then its also new candidate for pair
				end
			end
			if (ami < b*b)          % ami = 0 when complex zero pair
				n2 = n2-1;          % one more complex zero pair
				x1(n2) = -2*a;      
				x2(n2) = a*a+b*b;   % zeros distance from origo
				r(jj) = r(m);       % replace current zero with last zero
				m = m-1;            % reducing total amount of zeros so that this
									% new candidate dont get compared by itself
			else                 	% its real pole
				n1 = n1+1;          % one more real zero
				x1(n1) = -a;
				x2(n1) = 0;
			end
		end
		i = i+1;
	end %while
	% <--- sort real zeros: ------------------------------------------<< DH <<<
	for i = 1:n1
		a = -1E10;
		for j = i:n1
			if (x1(j) > a)
				a = x1(j);
				jj = j;
			end
		end
		x1(jj) = x1(i);
		x1(i) = a;
	end

	% <--- sort complex factors: -------------------------------------<< DH <<<
	m = n1;
	for i = n2:50
		m = m+1;
		b = 0;
		for j = i:50
			if (x2(j) > b)
				b = x2(j);
				jj = j;
			end
		end
		a = x1(jj);
		x1(jj) = x1(i);
		x2(jj) = x2(i);
		x1(m) = a;
		x2(m) = b;
	end
	clear c1;clear c2
	
	% <--- compute z-domain factors: ---------------------------------<< DH <<<
	% <--- Branch 1: --------------------------------------------------<<DH <<<
	ifirst1 = 0;iblo1 = 0;
	for i = 1:m
		if (x1(i) <=  0)
			if (i <=  n1)
				ifirst1 = ifirst1+1;
				iblo1 = ifirst1;                        % first order term
				c1(ifirst1) = -(1+x1(i))/(1-x1(i));     % 1 + c1*z^-1
				c2(ifirst1) = 0;                        % where
			else                                        % c1 = -(1+x1)/(1-x1)
				iblo1 = iblo1+1;
				c = 1-x1(i)+x2(i);                      % second order term
				c1(iblo1) = 2*(x2(i)-1)/c;              % 1 + c1*z^-1 + c2*z^-2
				c2(iblo1) = (1+x1(i)+x2(i))/c;          % where
			end                                         % c1 = 2*(x2-1)/(1-x1+x2)
		end                                             % c2 = (1+x1+x2)/(1-x1+x2)
	end

	% <--- Branch 2: -------------------------------------------------<< DH <<<
	ifirst2 = 0;iblo2 = 0;iblo = iblo1;
	for i = 1:m
		if (x1(i) > 0)
			if (i <=  n1)
				iblo = iblo+1;
				ifirst2 = ifirst2+1;             % first order term
				iblo2 = ifirst2;                 % 1 + c1*z^-1
				c1(iblo) = -(1-x1(i))/(1+x1(i)); % bilinear transformation  
				c2(iblo) = 0;                    % s = -(1-z)/(1+z)
			else                                 % c1 = -(1-x1)/(1+x1)
				iblo = iblo+1;                   % second order term
				iblo2 = iblo2+1;                 % 1 + c1*z^-1 + c2*z^-2
				c = 1+x1(i)+x2(i);               % where
				c1(iblo) = 2*(x2(i)-1)/c;        % c1 = 2*(x2-1)/(1+x1+x2)
				c2(iblo) = (1-x1(i)+x2(i))/c;    % c2 = (1-x1+x2)/(1+x1+x2)
			end
		end
	end

	% <--- Building coefficient vectors - version 3 ------------------<< DH <<<
	% <--- nonlinear phase (elliptic) design - idelay = 0 --------------<< DH <<<
	halfwc = 0; %halfway counter         
	an1 = 1;an2 = 1;                       % c1 and c2 contains 1st and 2nd order
	for i = 1:length(c1)                   % coefficients from both branches.
		if (c2(i) == 0)                    % First values belong to 1st branch
			halfwc = halfwc+1;             % and the rest belong to 2nd branch.
			an1 = conv(an1,[1 c1(i)]);     % Values are taken from c1 and c2 until
		else                               % it contains more than half the total.
			halfwc = halfwc+2;             % Or until order of an1 is more than
			an1 = conv(an1,[1 c1(i) c2(i)]); % half of order N. The rest values from
		end                                % vectors c1 and c2 belongs to an2
		% (branch2)  
		if (nbands == 4 & isequal(des,[0 -1 -2 -3]))
			if (halfwc >= fix(ncoe/2)+2 | halfwc >= ceil(ncoe/2)+2)  % 4 bands with
				break                                                % [0 -1 -2 -3]
			end
		else 
			if (halfwc >= fix(ncoe/2) | halfwc >= ceil(ncoe/2))  % 2 or 3 bands and
				break                                         % 4 bands with
			end                                               % [0 -1 0 -1]
		end
	end
	for j = i+1:length(c1)
		if (c2(j) == 0)
			halfwc = halfwc+1;
			an2 = conv(an2,[1 c1(j)]);
		else
			halfwc = halfwc+2;
			an2 = conv(an2,[1 c1(j) c2(j)]);
		end
		if (halfwc == ncoe) % testing if all values are delivered
			break
		end   
	end
	% <--- approximately linear phase design: - idelay > 0 -----------<< DH <<<
	if (idelay > 0 & idelay == fix(idelay))
		an1 = conv(an1,an2);
		an2 = [1 zeros(1,idelay)];
	end
	% <---------------------------------------------------------------<< DH <<<	
	% - Preparing some variables and save them to a file
	[Han1,wan1] = freqz(fliplr(an1),an1,8192);
	[Han2,wan2] = freqz(fliplr(an2),an2,8192);
	phasean1 = unwrap(angle(Han1));
	phasean2 = unwrap(angle(Han2));
	if (length(an1) > length(an2))   % - branch 1 always higher-order -- DH -- 
		PHA1 = phasean1; PHA2 = phasean2;
	else
		PHA1 = phasean2; PHA2 = phasean1;
	end

	% <--- These are only used to scale those response figures. ------<< DH <<<
	% <--- passband ripple and stopband attenuation ------------------<< DH <<<
	p = 0;s = 0;amp = 20*log10(abs(cos((PHA1-PHA2)/2)));
	if (fix(idelay) == idelay)  % to prevent printing in non-interger delay d ...
		for i = 1:nbands
			if (des(i) == 0 | des(i) == -2)  %passband
				ind = find(wan1 >= edge(2*i-1)*2*pi & wan1 <= edge(2*i)*2*pi);
				p = p+1;mamp1(p) = min(amp(ind)); 	 
				% fprintf('%1.0f. band ripple: %2.12f dB \n',i,abs(mamp1(p)));
				Att(i) = abs(mamp1(p));
			else            %stopband
				ind = find(wan1 >= edge(2*i-1)*2*pi & wan1 <= edge(2*i)*2*pi);
				s = s+1;mamp2(s) = max(amp(ind));	 
			%	fprintf('%1.0f. band attenuation: %2.3f dB \n',i,abs(mamp2(s)));
				Att(i) = abs(mamp2(s));
			end
		end
	end
	if (nbands == 1);
		passbr2 = 0;stopba2 = 0; % to prevent error message
	else
		passbr2 = mamp1(1);stopba2 = mamp2(1);
	end

	% Filtger orders 
	fprintf('\n');
	Branch1 = length(an1)-1
	Branch2 = length(an2)-1
	N = Branch1+Branch2
	Z1 = roots(fliplr(an1));
	P1 = roots(an1);
	Z2 = roots(fliplr(an2));
	P2 = roots(an2);
